#include <cassert>
#include <cstdio>
#include <ctime>
#include <cstdlib>
#include <cstring>
#include <cmath>
#include <algorithm>
#include <iostream>
#include <set>
#include <map>
#include <vector>
#include <queue>
#include <deque>
using namespace std;
#define pb push_back
#define mp make_pair
#define fs first
#define sc second
#define sz(a) ((int) (a).size())
#define eprintf(...) fprintf(stderr, __VA_ARGS__)
#define int64 long long
#define ldb long double
const double pi = acos(-1.0);
const int N = 55;
const int V = 111 * 55;
bool used[N][N], usedv[V];
int u, v, n, m, k, s, t;

struct edge {
	int tov, f, c, rnum;
	edge(int tov, int c, int rnum): tov(tov), f(0), c(c), rnum(rnum) {}
};

vector<edge> adj[V];
vector<int> init[N], who[N], nwho[N];

void add(int u, int v, int c) {
	edge e1(v, c, sz(adj[v])), e2(u, 0, sz(adj[u]));
	adj[u].pb(e1), adj[v].pb(e2);
}

bool dfs(int v, int t) {
	if (usedv[v]) return false;
	if (v == t) return true;
	usedv[v] = true;
	for (int i = 0; i < sz(adj[v]); ++i)
		if ((adj[v][i].c - adj[v][i].f > 0) && dfs(adj[v][i].tov, t)) {
			adj[v][i].f++;
			adj[adj[v][i].tov][adj[v][i].rnum].f--;
			return true;
		}
	return false;
}

bool check(int d) {
	for (int i = 0; i < (d + 1) * n; ++i)
		adj[i].clear();
	for (int i = 0; i < d; ++i)
		for (int u = 0; u < n; ++u) {
			for (int j = 0; j < sz(init[u]); ++j) {
				int v = init[u][j];
				add(i * n + u, (i + 1) * n + v, 1);
			}
			add(i * n + u, (i + 1) * n + u, N);
		}
	int res = 0;
	while (true) {
		for (int i = 0; i < (d + 1) * n; ++i)
			usedv[i] = false;
		if (!dfs(0 * n + s, d * n + t)) break;
		++res;
	}
	return (res >= k);
}

int main() {
	//assert(freopen("input.txt", "r", stdin));
	//assert(freopen("output.txt", "w", stdout));
	scanf("%d%d%d%d%d", &n, &m, &k, &s, &t);
	--s, --t;
	for (int i = 0; i < m; ++i) {
		scanf("%d%d", &u, &v), --u, --v;
		init[u].pb(v), init[v].pb(u);
	}
	int l = 1, r = n + k + 1;
	while (l < r) {
		int q = (l + r) / 2;
		if (check(q))
			r = q;
		else
			l = q + 1;
	}
	assert(check(r));
	printf("%d\n", r);
	for (int i = 0; i < k; ++i)
		who[s].pb(i);
	reverse(who[s].begin(), who[s].end());
	for (int i = 0; i < r; ++i) {
		memset(used, 0, sizeof(used));
		for (int u = i * n; u < (i + 1) * n; ++u)
			for (int j = 0; j < sz(adj[u]); ++j) {
				int v = adj[u][j].tov;
				if (adj[u][j].f > 0) used[u % n][v % n] = true;
			}
		for (int u = 0; u < n; ++u)
			nwho[u].clear();
		vector< pair<int, int> > ship;
		for (int u = 0; u < n; ++u)
			for (int v = 0; v < n; ++v)
				if (used[u][v] && !used[v][u]) {
					assert(!who[u].empty());
					nwho[v].pb(who[u].back());
					ship.pb(mp(who[u].back(), v));
					who[u].pop_back();
				}
		printf("%d", sz(ship));
		sort(ship.begin(), ship.end());
		for (int j = 0; j < sz(ship); ++j)
			printf(" %d %d", ship[j].fs + 1, ship[j].sc + 1);
		printf("\n");
		for (int u = 0; u < n; ++u)
			for (int i = 0; i < sz(nwho[u]); ++i)
				who[u].pb(nwho[u][i]);
	}
	return 0;
}